/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import org.jetbrains.annotations.NotNull;

public class RepositorySourceMaker
implements class_3285 {
    private static final FileFilter DATAPACK_FILTER = pack -> {
        if (pack.isFile() && pack.getName().endsWith(".zip")) {
            try {
                FileSystem pfs = FileSystems.newFileSystem(pack.toPath());
                Path pth = pfs.getPath("data/", new String[0]);
                return Files.exists(pth, new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return pack.isDirectory() && new File(pack, "pack.mcmeta").isFile() && new File(pack, "data/").exists();
    };
    private final Map<Path, FilePackType> packs;
    private final class_5352 packSource;

    public RepositorySourceMaker(class_5352 packSource, Set<Path> files) {
        this.packSource = packSource;
        this.packs = new HashMap<Path, FilePackType>();
        for (Path file : files) {
            this.packs.put(file, FilePackType.MISSING);
        }
    }

    private void updatePacks() {
        for (Path file : this.packs.keySet()) {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.endsWith(".zip")) {
                this.packs.put(file, FilePackType.ZIPED_PACK);
            } else if (Files.isDirectory(file, new LinkOption[0]) && Files.exists(file.resolve("pack.mcmeta"), new LinkOption[0])) {
                this.packs.put(file, FilePackType.UNZIPED_PACK);
            } else {
                try {
                    if (Files.notExists(file, new LinkOption[0])) {
                        Files.createDirectories(file, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.packs.put(file, FilePackType.PACK_FOLDER);
        }
    }

    public void method_14453(@NotNull Consumer<class_3288> packConsumer, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_3288.class_5351 packBuilder) {
        this.updatePacks();
        block4: for (Path file : this.packs.keySet()) {
            FilePackType type = this.packs.get(file);
            switch (type) {
                case UNZIPED_PACK: 
                case ZIPED_PACK: {
                    class_3288 pack = class_3288.method_14456((String)file.getFileName().toString(), (boolean)true, this.createSupplier(file), (class_3288.class_5351)packBuilder, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)this.packSource);
                    if (pack == null) break;
                    packConsumer.accept(pack);
                    break;
                }
                case PACK_FOLDER: {
                    class_3288 pack;
                    File[] afile = file.toFile().listFiles(DATAPACK_FILTER);
                    if (afile == null) continue block4;
                    for (File packFile : afile) {
                        pack = class_3288.method_14456((String)packFile.getName(), (boolean)true, this.createSupplier(packFile.toPath()), (class_3288.class_5351)packBuilder, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)this.packSource);
                        if (pack == null) continue;
                        packConsumer.accept(pack);
                    }
                    continue block4;
                }
            }
        }
    }

    private Supplier<class_3262> createSupplier(Path pack) {
        return Files.isDirectory(pack, new LinkOption[0]) ? () -> new class_3259(pack.toFile()) : () -> new class_3258(pack.toFile());
    }

    private static enum FilePackType {
        MISSING,
        ZIPED_PACK,
        UNZIPED_PACK,
        PACK_FOLDER;

    }
}

